{========================================================================}
{=                (c) 1995-98 SwiftSoft Ronald Dittrich                 =}
{========================================================================}
{=                          All Rights Reserved                         =}
{========================================================================}
{=  D 01099 Dresden             = Fax.: +49 (0)351-8037944              =}
{=  Loewenstr.7a                = info@swiftsoft.de                     =}
{========================================================================}
{=  Actual versions on http://www.swiftsoft.de/mmtools.html             =}
{========================================================================}
{=  This code is for reference purposes only and may not be copied or   =}
{=  distributed in any format electronic or otherwise except one copy   =}
{=  for backup purposes.                                                =}
{=                                                                      =}
{=  No Delphi Component Kit or Component individually or in a collection=}
{=  subclassed or otherwise from the code in this unit, or associated   =}
{=  .pas, .dfm, .dcu, .asm or .obj files may be sold or distributed     =}
{=  without express permission from SwiftSoft.                          =}
{=                                                                      =}
{=  For more licence informations please refer to the associated        =}
{=  HelpFile.                                                           =}
{========================================================================}
{=  $Date: 02.04.98 - 19:52:53 $                                        =}
{========================================================================}
unit Unit1;

interface

uses Windows, SysUtils, Classes, Graphics, Forms, Controls, StdCtrls,
  Buttons, ComCtrls, ExtCtrls, MMSystem, MMRegs, MMPCMSup,MMACMSup, MMObj,
  MMDSPObj, MMWave, MMACMDlg, MMUtils;

type
  TMainForm = class(TForm)
    MMACM1: TMMACM;
    btnStart: TButton;
    btnStop: TButton;
    MMWaveFile1: TMMWaveFile;
    btnConvert: TButton;
    procedure btnStartClick(Sender: TObject);
    procedure btnStopClick(Sender: TObject);
    procedure btnConvertClick(Sender: TObject);
  private
  public
    FPACMConvert: PACMConvert;
    FSrcBuffer: PChar;
    FDstBuffer: PChar;
  end;

var
  MainForm: TMainForm;

implementation

{$R *.DFM}

{==============================================================================}
function acmBuildGSM610Header(SampleRate: integer): PGSM610WaveFormat;
begin
   Result := GlobalAllocMem(sizeOf(TGSM610WaveFormat));
   with Result^ do
   begin
      wfx.wFormatTag     := WAVE_FORMAT_GSM610;
      wfx.nChannels      := 1;
      wfx.nSamplesPerSec := SampleRate;
      wfx.wBitsPerSample := 0;
      wfx.nAvgBytesPerSec:= 0;
      wfx.nBlockAlign    := 65;
      wfx.cbSize         := 2;
      wSamplesPerBlock   := 320;

      case SampleRate of
         8000 : wfx.nAvgBytesPerSec := 1625;
         11025: wfx.nAvgBytesPerSec := 2239;
         22050: wfx.nAvgBytesPerSec := 4478;
         44100: wfx.nAvgBytesPerSec := 8957;
      end;
   end;
end;

{------------------------------------------------------------------------------}
procedure TMainForm.btnStartClick(Sender: TObject);
var
   wfx: TWaveformatEx;

begin
   if MMACM1.ChooseFormat(nil,'Select Format') then
   begin
      // setup a source PCM format
      pcmBuildWaveHeader(@wfx,16,1,22050);

      // alloc a buffer for conversion
      FSrcBuffer := GlobalAllocPtr(GPTR, 4096);

      // setup our conversion instance
      FPACMConvert := acmBeginConvert(@wfx,MMACM1.PWaveFormat,
                                      FSrcBuffer,4096,True);
      if (FPACMConvert = nil) then
          raise Exception.Create('Unable to convert to destination format');

      // The destination buffer is allocated from acmBeginConvert
      FDstBuffer := FPACMConvert.lpDstBuffer;

      { create a destination file }
      MMWaveFile1.Wave.CreateFile('C:\TEST.WAV',MMACM1.PWaveFormat);

      btnStart.Enabled   := False;
      btnStop.Enabled    := True;
      btnConvert.Enabled := True;
   end;
end;

procedure TMainForm.btnStopClick(Sender: TObject);
begin
   // playing has stopped, free all
   MMWaveFile1.Wave.CloseFile;
   acmDoneConvert(FPACMConvert);
   GlobalFreePtr(FSrcBuffer);

   btnStart.Enabled   := True;
   btnStop.Enabled    := False;
   btnConvert.Enabled := False;
end;

procedure TMainForm.btnConvertClick(Sender: TObject);
var
   nConvert: Longint;

begin
   // we fill our source buffer here, you must your data in the buffer
   FillChar(FSrcBuffer^,4096,0);

   // do the conversion
   nConvert := acmDoConvert(FPACMConvert, 4096);

   if (nConvert > 0) then
   begin
      // write the data out
      MMWaveFile1.Wave.WriteDataBytes(FDstBuffer, nConvert);

      // update the bytes you have read
      dec(FPACMConvert.dwBytesRead,nConvert);
   end;
end;

end.



